#include <string>
#include <iostream>
#include <vector>

#include "matlabfile.h"

int main()
{
  using namespace MatlabUtilities;

  try
  {
    File matlabfile("test_data.mat");
    
    std::string test_string;
    matlabfile.read<Types::string>("test_string", test_string);
    std::cout << "test_string: " << test_string << std::endl;
    
    double value;
    matlabfile.read<Types::real>("test_real", value);
    std::cout << "test_real: " << value << std::endl;
    
    std::vector<double> test_vec;
    matlabfile.read<Types::real_vector>("test_vec", test_vec);
    std::cout << "test_vec:";
    for(size_t i = 0; i < test_vec.size(); ++i)
      std::cout << " " << test_vec[i];
    std::cout << std::endl;
    
    matlabfile.read<Types::real_vector>("test_vect", test_vec);
    std::cout << "test_vect:";
    for(size_t i = 0; i < test_vec.size(); ++i)
      std::cout << " " << test_vec[i];
    std::cout << std::endl;
  
    matlabfile.read<Types::fixed_length_real_vector<6> >("test_vect", test_vec);
    std::cout << "test_vect:";
    for(size_t i = 0; i < test_vec.size(); ++i)
      std::cout << " " << test_vec[i];
    std::cout << std::endl;
    
    double arr[6];
    matlabfile.read<Types::fixed_length_real_vector<6> >("test_vec", arr);
    std::cout << "test_vec:";
    for(size_t i = 0; i < 6; ++i)
      std::cout << " " << arr[i];
    std::cout << std::endl;
  }
  catch (std::exception& e)
  {
    std::cout << "Exception: " << e.what() << std::endl;
  }
  
  try
  {
    File matlabfile("test_out.mat", true);
     
    matlabfile.write<Types::string>("HelloWorld1", "Hello world!");
    
    std::string hw = "Hello world!";
    matlabfile.write<Types::string>("HelloWorld2", hw);
  }
  catch (std::exception& e)
  {
    std::cout << "Exception: " << e.what() << std::endl;
  }
  
  return 1;
}
